<?php
// Защита от прямого доступа
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// 1. Подключение скрипта IMask
add_action('wp_enqueue_scripts', 'frontpad_enqueue_imask');
function frontpad_enqueue_imask() {
    if (is_checkout()) {
        // Подключаем современную маску IMask (CDN)
        wp_enqueue_script('imask', 'https://unpkg.com/imask@7.6.1/dist/imask.min.js', array(), '7.6.1', true);
    }
}

// 2. Скрипт инициализации маски и кнопки бонусов
add_action('wp_footer', 'frontpad_phone_script', 999);
function frontpad_phone_script() {
    if (is_checkout()) {
        ?>
        <script type="text/javascript">
            jQuery(document).ready(function($) {
                // --- НАСТРОЙКА МАСКИ ---
                var phoneInput = document.getElementById('billing_phone');
                var phoneMask = null;
                
                if (phoneInput) {
                    var maskOptions = {
                        mask: '{7}(000)000-00-00', // Формат: 7(999)123-45-67
                        lazy: true,               // Показывать маску сразу (____)
                        placeholderChar: '_'       // Символ пустого места
                    };
                    try {
                        phoneMask = IMask(phoneInput, maskOptions);
                        
                        // Удобство: при клике на пустом поле курсор встает после семерки
                        phoneInput.addEventListener('click', function () {
                            if (phoneMask.unmaskedValue === '7') { 
                                phoneMask.updateValue();
                                phoneInput.setSelectionRange(2, 2); 
                            }
                        });
                    } catch (e) {
                        console.error("IMask error:", e);
                    }
                }

                // --- ЛОГИКА КНОПКИ БОНУСОВ ---
                var $phoneField = $('#billing_phone_field');
                
                // Добавляем кнопку и блок ответа
                $phoneField.append('<div style="margin-top:10px;"><button type="button" id="check_bonuses" class="button" style="margin-right:10px;">Проверить бонусы</button><span id="client-score" style="font-weight:bold; color:#2c3e50;"></span></div>');

                $('#check_bonuses').on('click', function(e) {
                    e.preventDefault();
                    
                    // Берем "чистый" номер (только цифры)
                    // Приоритет: данные из маски, иначе очистка value вручную
                    var rawPhone = phoneMask ? phoneMask.unmaskedValue : $('#billing_phone').val().replace(/[^0-9]/g, '');
                    
                    // Если номер начинается не с 7 (например, клиент ввел 8), меняем на 7
                    if (rawPhone.length === 11 && rawPhone[0] === '8') {
                        rawPhone = '7' + rawPhone.substring(1);
                    }

                    // Проверка формата (должно быть 11 цифр, начинаться с 7)
                    if (rawPhone.length !== 11 || rawPhone[0] !== '7') {
                        $('#client-score').html('<span style="color:#e74c3c;">Введите полный номер телефона</span>');
                        return;
                    }

                    // Визуализация загрузки
                    var $btn = $(this);
                    var originalText = $btn.text();
                    $btn.prop('disabled', true).text('Загрузка...');
                    $('#client-score').text('');

                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        type: 'POST',
                        data: {
                            action: 'get_frontpad_client_score',
                            phone: rawPhone
                        },
                        success: function(response) {
                            $btn.prop('disabled', false).text(originalText);
                            if (response.success) {
                                $('#client-score').html('<span style="color:#27ae60;">Баллы: ' + response.data.score + '</span>');
                            } else {
                                $('#client-score').html('<span style="color:#c0392b;">' + (response.data.message || 'Ошибка') + '</span>');
                            }
                        },
                        error: function() {
                            $btn.prop('disabled', false).text(originalText);
                            $('#client-score').html('<span style="color:#c0392b;">Ошибка соединения</span>');
                        }
                    });
                });
            });
        </script>
        <?php
    }
}
