<?php
/* ====================================
 * Plugin Name: Синхронизация Frontpad и Woocommerce
 * Description: Плагин для синхронизации Frontpad с WooCommerce (Заказы, Бонусы, Предзаказ)
 * Author:      Allslava
 * Author URI:  https://allslava.ru/
 * Plugin URI:  https://allslava.ru/plagin-dlya-sinhronizacii-vukommers-i-frontpad/
 * Version: 1.6.2
 * ==================================== */

// ПОДКЛЮЧЕНИЕ МОДУЛЕЙ
require_once plugin_dir_path(__FILE__) . 'frontpad-preorder.php'; // Календарь и время
require_once plugin_dir_path(__FILE__) . 'frontpad-phone.php';    // Маска телефона и кнопка

// API-ключ: Регистрация настроек
add_action('admin_init', 'frontpad_register_settings');
function frontpad_register_settings() {
    register_setting('frontpad_options', 'frontpad_api_secret');
}

add_action('admin_menu', 'frontpad_add_settings_page');
function frontpad_add_settings_page() {
    add_options_page('Frontpad Settings', 'Frontpad', 'manage_options', 'frontpad', 'frontpad_settings_page');
}

function frontpad_settings_page() {
    ?>
    <div class="wrap">
        <h2>Frontpad API Settings</h2>
        <form method="post" action="options.php">
            <?php settings_fields('frontpad_options'); ?>
            <table class="form-table">
                <tr>
                    <th>API Secret</th>
                    <td><input type="text" name="frontpad_api_secret" value="<?php echo get_option('frontpad_api_secret'); ?>" size="50"></td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

// ---------------------------------------------------------
// API ЗАПРОСЫ (AJAX ПРОВЕРКА БОНУСОВ + ОТПРАВКА ЗАКАЗА)
// ---------------------------------------------------------

// 1. AJAX-обработчик проверки бонусов (Серверная часть)
add_action('wp_ajax_get_frontpad_client_score', 'get_frontpad_client_score');
add_action('wp_ajax_nopriv_get_frontpad_client_score', 'get_frontpad_client_score');
function get_frontpad_client_score() {
    $phone = sanitize_text_field($_POST['phone']);
    $ip = $_SERVER['REMOTE_ADDR'];
    $secret = get_option('frontpad_api_secret');

    // Ограничения (Anti-spam)
    $ip_key_sec = 'bonus_check_ip_' . md5($ip) . '_last_time';
    $ip_key_day = 'bonus_check_ip_' . md5($ip) . '_day';
    $last_time = get_transient($ip_key_sec);
    $ip_day_count = (int) get_transient($ip_key_day);

    if ($last_time && (time() - $last_time < 1)) {
        wp_send_json_error(array('message' => 'Слишком частые запросы.'));
        return;
    }
    if ($ip_day_count >= 15) { // Лимит на IP
        wp_send_json_error(array('message' => 'Лимит запросов исчерпан.'));
        return;
    }

    $query = http_build_query(array(
        'secret' => $secret,
        'client_phone' => $phone
    ));

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://app.frontpad.ru/api/index.php?get_client');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $query);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);

    if (isset($data['result']) && $data['result'] === 'success') {
        // Обновляем счетчики только при успехе (или при попытке)
        set_transient($ip_key_sec, time(), 1);
        set_transient($ip_key_day, $ip_day_count + 1, 86400);
        
        wp_send_json_success(array('score' => $data['score']));
    } else {
        $msg = isset($data['error']) ? $data['error'] : 'Клиент не найден';
        wp_send_json_error(array('message' => $msg));
    }
}

// 2. Отправка нового заказа во Frontpad
add_action( 'woocommerce_order_status_processing', 'otpravka_zakaza_v_frontpad', 10, 1 ); 
function otpravka_zakaza_v_frontpad( $order_id ) {
    if(get_post_meta($order_id, '_frontpad_order_sent', true)) {
        return;
    }
    $order         = wc_get_order( $order_id );
    $email         = $order->get_billing_email();
    
    // Очистка телефона для API
    $phone_raw     = $order->get_billing_phone();
    $phone         = preg_replace('/[^0-9]/', '', $phone_raw); // Оставляем только цифры
    
    // Тип доставки/оплаты
    $shipping_type = $order->get_shipping_method();
    if ( $order->get_payment_method_title() == 'Оплата при получении' ) {
        $shipping_type = '';
    } else {
        $shipping_type = 947; // ID типа оплаты (безнал и т.д.)
    }
    
    $items      = $order->get_items();
    $item_qty   = array();
    $item_sku   = array();

    $user_id        = $order->get_user_id();
    $address_fields = array('country', 'title', 'given_name', 'surname', 'street', 'house', 'pod', 'et', 'apart');
    
    // Сбор адреса
    $address = array();
    $order_details = array();
    foreach ( $order->get_meta_data() as $item ) {
        $order_details[ $item->jsonSerialize()['key'] ] = $item->jsonSerialize()['value'];
    }

    if ( is_array( $address_fields ) ) {
        foreach ( $address_fields as $field ) {
            $address[ 'billing_' . $field ]  = get_user_meta( $user_id, 'billing_' . $field, true );
            $address[ 'shipping_' . $field ] = get_user_meta( $user_id, 'shipping_' . $field, true );
            $address[ 'billing_' . $field ]  = isset($order_details[ '_billing_' . $field ]) ? $order_details[ '_billing_' . $field ] : '';
            $address[ 'shipping_' . $field ] = isset($order_details[ '_shipping_' . $field ]) ? $order_details[ '_shipping_' . $field ] : '';
        }
    }
    $address['pre_order'] = get_post_meta( $order_id, 'pre_order', true );

    foreach ( $items as $item_id => $item ) {
        $item_qty[]           = $item->get_quantity();
        $product              = $item->get_product();
        $item_sku[] = $product ? $product->get_sku() : '';
    }

    // Время предзаказа (из нашего нового модуля)
    $pre_order_time = get_post_meta( $order_id, 'pre_order_time', true );

    $data = array(
        'secret'   => get_option('frontpad_api_secret'),
        'street'   => $address['billing_street'],
        'home'     => $address['billing_house'],
        'pod'      => $address['billing_pod'],
        'et'       => $address['billing_et'],
        'apart'    => $address['billing_apart'],
        'phone'    => $phone,
        'mail'     => $email,
        'descr'    => $order->get_customer_note(),
        'name'     => $address['billing_given_name'] . ' ' . $address['billing_surname'],
        'pay'      => $shipping_type,
        'datetime' => date( 'Y-m-d H:i:s', $order->get_date_created()->getOffsetTimestamp() ),
    );

    // Подстановка адреса доставки, если он есть
    if ( $address['shipping_street'] != "" ) $data['street'] = $address['shipping_street'];
    if ( $address['shipping_house'] != "" ) $data['home'] = $address['shipping_house'];
    if ( $address['shipping_pod'] != "" ) $data['pod'] = $address['shipping_pod'];
    if ( $address['shipping_et'] != "" ) $data['et'] = $address['shipping_et'];
    if ( $address['shipping_apart'] != "" ) $data['apart'] = $address['shipping_apart'];
    if ( ( $address['shipping_given_name'] != "" ) && ( $address['shipping_surname'] != "" ) ) {
        $data['name'] = $address['shipping_given_name'] . ' ' . $address['shipping_surname'];
    }

    // Приоритет времени: 1. Явный предзаказ (pre_order_time) 2. Старый формат 3. Текущее
    if ( !empty($pre_order_time) ) {
        $data['datetime'] = $pre_order_time;
    } elseif ( $address['pre_order'] != '' ) {
        $data['datetime'] = date( 'Y-m-d H:i:s', strtotime( $address['pre_order'] ) );
    }

    foreach ( $order->get_items( 'shipping' ) as $item_id => $shipping_item_obj ) {
        $data['descr'] = $data['descr'] . '. ' . $shipping_item_obj->get_method_title();
    }

    $query = '';
    foreach ( $data as $key => $value ) {
        $query .= "&" . $key . "=" . urlencode($value);
    }
    foreach ( $item_sku as $key => $value ) {
        $query .= "&product[" . $key . "]=" . urlencode($value);
        $query .= "&product_kol[" . $key . "]=" . urlencode($item_qty[ $key ]);
    }

    $ch = curl_init();
    curl_setopt( $ch, CURLOPT_URL, "https://app.frontpad.ru/api/index.php?new_order" );
    curl_setopt( $ch, CURLOPT_FAILONERROR, 1 );
    curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
    curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
    curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, false );
    curl_setopt( $ch, CURLOPT_TIMEOUT, 30 );
    curl_setopt( $ch, CURLOPT_POST, 1 );
    curl_setopt( $ch, CURLOPT_HEADER, false );
    curl_setopt( $ch, CURLOPT_POSTFIELDS, $query );
    $response = curl_exec( $ch );
    curl_close( $ch );

    $response = json_decode( $response, true );

    if ( isset($response['result']) && $response['result'] == 'success' ) {
        update_post_meta( $order_id, '_frontpad_order_sent', true);
        update_post_meta( $order_id, 'Frontpad Order ID', sanitize_text_field( $response['order_id'] ) );
        update_post_meta( $order_id, 'Frontpad Order Number', sanitize_text_field( $response['order_number'] ) );
    } else {
        // Логирование ошибок (опционально можно раскомментировать error_log)
        // error_log('Frontpad Error: ' . print_r($response, true));
        $order->update_status( 'failed' );
    }
}
