<?php
/**
 * Plugin Name: WooCommerce Catalog Mode (Budu Buuzy Custom)
 * Description: Полностью отключает возможность покупки и корзину, переводя сайт в режим витрины.
 * Version: 1.0
 * Author: Allslava.ru
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Защита от прямого доступа

// 1. Делаем все товары недоступными для покупки
add_filter( 'woocommerce_is_purchasable', '__return_false' );

// 2. Скрываем кнопки "В корзину" в каталоге и на карточках товаров
add_action( 'init', 'bb_remove_add_to_cart_buttons' );
function bb_remove_add_to_cart_buttons() {
    remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
}

// 3. Отключаем доступ к страницам Корзины и Оформления заказа (редирект на главную)
add_action( 'template_redirect', 'bb_redirect_checkout_pages' );
function bb_redirect_checkout_pages() {
    if ( is_cart() || is_checkout() ) {
        wp_redirect( home_url() );
        exit;
    }
}

// 4. (Опционально) Заменяем цену на текст (раскомментируйте, если нужно скрыть цены)
// add_filter( 'woocommerce_get_price_html', 'bb_replace_price_text' );
// function bb_replace_price_text( $price ) {
//     return 'Временно недоступно';
// }
